fn PxIsClothMod modCloth =
(
	(classOf modCloth) == mCloth
)

fn PxCreateAsCloth =
(
	currentNode = PxGetCurrentNode()
	if currentNode != undefined then
	(
		if PxSeletionCanCreateCloth() then 
		(
			PxClothNodes (PxGetSelectedNodes())
			if (PxGetSelectionCount()) == 1 then (max modify mode)
			px_selectionChanged()  -- Update PhysX Tools dialog
		)
		else
		(
			Messagebox nvpxText.TXT_MODIFIERCLOTH_NOT_ALLOWED
		)
	)	
)

fn PxRemoveCloth =
(
	selNodes = PxGetSelectedNodes()
	
	for currentNode in selNodes do
	( 
		PxRemoveClothMod currentNode
	)
)

-- If adding a MassFX Cloth modifier, prepare to remove the previous one so there is only one on the stack
fn PxClothModifierPreAdded =
(

	t = callbacks.notificationParam()
	node = t[1]
	modCloth  = t[2]
	
	if (node != undefined) then
	(
		if PxIsClothMod(modCloth) then 
		(
			PxStopSimulation()
			-- cancel this addition
			existingClothMod = PxGetModCloth node
				
			if (existingClothMod != undefined) then
				PxAddModifierToTrash node modCloth
		)	
	)
)

-- Delete a modifer that was prepared to be deleted, and setup the physical mesh
fn PxClothModifierPostAdded =
(
	t = callbacks.notificationParam()
	node = t[1]
	
	if node != undefined then
	(
		modCloth  = t[2]
		
		-- If we added a MassFX Cloth...
		if PxIsClothMod(modCloth) then 
		(
			-- Remove new modifier on this node
			PxEmptyModifierTrash node modCloth
		)
	)	
)

-- If the modifier is being deleted, stop the simulation
fn PxClothModifierPreDelete =
(
	t = callbacks.notificationParam()
	node = t[1]
	mod  = t[2]
	
	if PxIsClothMod(mod) then
	(
		PxStopSimulation()
	)
)

-- Intialize the callbacks
callbacks.removeScripts id:#MassFXClothModifier
callbacks.addScript #preModifierAdded    "PxClothModifierPreAdded()"       id:#MassFXClothModifier
callbacks.addScript #postModifierAdded   "PxClothModifierPostAdded()"      id:#MassFXClothModifier
callbacks.addScript #preModifierDeleted  "PxClothModifierPreDelete()"      id:#MassFXClothModifier
